/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.SpeedBarListener;
import java.applet.Applet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JScrollBar;
import javax.swing.JSlider;

public class Animator
extends Thread {
    public static final int INITIAL = 0;
    public static final int RUNNING = 1;
    public static final int STEPPING = 2;
    public static final int CALLING = 3;
    public static final int STOPPING = 4;
    public static final int STOPPED = 5;
    public static final int FINISHED = 6;
    public static final int TERMINATING = 7;
    private static final double SLOW_DELAY = 1000.0;
    private static final double CLIP_DELAY = 200.0;
    private static final double FAST_DELAY = 0.0;
    private static HashMap<Applet, ArrayList<Thread>> animatorTable = new HashMap();
    private int animatorState = 0;
    private int currentDepth = 0;
    private int callDepth = 0;
    private int delayCount = 0;
    private double animatorSpeed = 0.5;
    private boolean resumed;

    public Animator() {
        this.initAnimator();
    }

    public Animator(ThreadGroup group) {
        super(group, (Runnable)null);
        this.initAnimator();
    }

    public Animator(Runnable runnable) {
        super(runnable);
        this.initAnimator();
    }

    public Animator(ThreadGroup group, Runnable runnable) {
        super(group, runnable);
        this.initAnimator();
    }

    public void run() {
    }

    public int getAnimatorState() {
        return this.animatorState;
    }

    public void pause(double milliseconds) {
        if (this.animatorState == 7) {
            this.terminate();
        }
        JTFTools.pause(milliseconds);
    }

    public void startAction() {
        this.start(1);
    }

    public void stopAction() {
        switch (this.animatorState) {
            case 1: 
            case 2: 
            case 3: {
                this.animatorState = 4;
                break;
            }
        }
    }

    public void stepAction() {
        this.start(2);
    }

    public void callAction() {
        this.callDepth = this.currentDepth;
        this.start(3);
    }

    public boolean buttonAction(String actionCommand) {
        if (actionCommand.equals("Start")) {
            this.startAction();
        } else if (actionCommand.equals("Stop")) {
            this.stopAction();
        } else if (actionCommand.equals("Step")) {
            this.stepAction();
        } else if (actionCommand.equals("Call")) {
            this.callAction();
        } else {
            return false;
        }
        return true;
    }

    public void setSpeed(double speed) {
        this.animatorSpeed = speed;
    }

    public double getSpeed() {
        return this.animatorSpeed;
    }

    public void trace() {
        this.trace(0);
    }

    public void trace(int depth) {
        if (Thread.currentThread() != this) {
            throw new ErrorException("trace() can be called only by the animator thread itself");
        }
        this.currentDepth = depth;
        switch (this.animatorState) {
            case 1: {
                this.delay();
                break;
            }
            case 2: 
            case 4: {
                this.breakpoint();
                break;
            }
            case 3: {
                if (this.callDepth < this.currentDepth) {
                    this.delay();
                    break;
                }
                this.breakpoint();
                break;
            }
            case 7: {
                this.terminate();
            }
        }
    }

    public void breakpoint() {
        if (Thread.currentThread() != this) {
            throw new ErrorException("breakpoint() can be called only by the animator thread itself");
        }
        this.animatorState = 5;
        this.breakHook();
        this.suspendAnimator();
    }

    public void delay() {
        boolean yield = true;
        double delay = 0.0;
        if (this.animatorSpeed < 0.25) {
            delay = 1000.0 + this.animatorSpeed / 0.25 * -800.0;
        } else if (this.animatorSpeed < 0.9) {
            delay = 200.0 + Math.sqrt((this.animatorSpeed - 0.25) / 0.65) * -200.0;
        } else {
            switch ((int)(this.animatorSpeed * 99.99 - 90.0)) {
                case 0: {
                    yield = true;
                    break;
                }
                case 1: {
                    yield = this.delayCount % 10 != 0;
                    break;
                }
                case 2: {
                    yield = this.delayCount % 7 != 0;
                    break;
                }
                case 3: {
                    yield = this.delayCount % 5 != 0;
                    break;
                }
                case 4: {
                    yield = this.delayCount % 3 != 0;
                    break;
                }
                case 5: {
                    yield = this.delayCount % 2 == 0;
                    break;
                }
                case 6: {
                    yield = this.delayCount % 3 == 0;
                    break;
                }
                case 7: {
                    yield = this.delayCount % 4 == 0;
                    break;
                }
                case 8: {
                    yield = this.delayCount % 6 == 0;
                    break;
                }
                case 9: {
                    yield = false;
                }
            }
            this.delayCount = (this.delayCount + 1) % 420;
        }
        if (yield) {
            this.delayHook();
            JTFTools.pause(delay);
        }
    }

    public void registerSpeedBar(JSlider slider) {
        SpeedBarListener.register(this, slider);
    }

    public void registerSpeedBar(JScrollBar scrollBar) {
        SpeedBarListener.register(this, scrollBar);
    }

    public void requestTermination() {
        this.animatorState = 7;
    }

    public void checkForTermination() {
        if (this.animatorState == 7) {
            this.terminate();
        } else {
            Animator.yield();
        }
    }

    public static void shutdown(Applet applet) {
        try {
            Class<?> threadClass = Class.forName("java.lang.Thread");
            Method stop = threadClass.getMethod("stop", new Class[0]);
            Object[] args = new Object[]{};
            ArrayList<Thread> list = animatorTable.get(applet);
            if (list != null) {
                animatorTable.remove(applet);
                int nThreads = list.size();
                int i = 0;
                while (i < nThreads) {
                    Thread t = list.get(i);
                    stop.invoke((Object)t, args);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void delayHook() {
    }

    protected void breakHook() {
    }

    protected void resumeHook() {
    }

    protected void controllerHook() {
    }

    public void start() {
        this.start(1);
    }

    private void initAnimator() {
        Applet applet = JTFTools.getApplet();
        if (applet != null) {
            JTFTools.registerApplet(applet, this);
            ArrayList<Thread> list = animatorTable.get(applet);
            if (list == null) {
                list = new ArrayList();
                animatorTable.put(applet, list);
            }
            list.add(this);
        }
    }

    private void start(int state) {
        switch (this.animatorState) {
            case 0: 
            case 6: {
                this.animatorState = state;
                this.resumeHook();
                this.controllerHook();
                super.start();
                break;
            }
            case 5: {
                this.animatorState = state;
                this.resumeHook();
                this.controllerHook();
                this.resumeAnimator();
                break;
            }
        }
    }

    private synchronized void suspendAnimator() {
        this.resumed = false;
        while (!this.resumed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void resumeAnimator() {
        this.resumed = true;
        this.notifyAll();
    }

    private void terminate() {
        if (Thread.currentThread() == this) {
            throw new ThreadDeath();
        }
        throw new ErrorException("Illegal call to terminate");
    }
}

